/**
  ******************************************************************************
  * @file    py32l090_hal_msp.c
  * @author  MCU Application Team
  * @brief   This file provides code for the MSP Initialization
  *          and de-Initialization codes.
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2023 Puya Semiconductor Co.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by Puya under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2016 STMicroelectronics.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by ST under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  */

/* Includes ------------------------------------------------------------------*/
#include "main.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* External functions --------------------------------------------------------*/

/**
  * @brief Initialize global MSP.
  */
void HAL_MspInit(void)
{
  __HAL_RCC_SYSCFG_CLK_ENABLE();
  __HAL_RCC_PWR_CLK_ENABLE();
}

/**
* @brief SCI MSP Initialization
* This function configures the hardware resources used in this example
* @param hsci: SCI handle pointer
* @retval None
*/
void HAL_SCI_MspInit(SCI_HandleTypeDef* hsci)
{
  GPIO_InitTypeDef GPIO_InitStruct = {0};
  if(hsci->Instance == USART1)
  {
    /* Peripheral clock enable */
    __HAL_RCC_USART1_CLK_ENABLE();
    /* DMA controller clock enable */
    __HAL_RCC_DMA_CLK_ENABLE();
    __HAL_RCC_GPIOB_CLK_ENABLE();
    
    /**USART1 GPIO Configuration
    PB11    ------> USART1_RX
    PB12    ------> USART1_TX
    */
    GPIO_InitStruct.Pin       = GPIO_PIN_11 | GPIO_PIN_12;
    GPIO_InitStruct.Mode      = GPIO_MODE_AF_PP;
    GPIO_InitStruct.Pull      = GPIO_PULLUP;
    GPIO_InitStruct.Speed     = GPIO_SPEED_FREQ_HIGH;
    GPIO_InitStruct.Alternate = GPIO_AF11_USART1;
    HAL_GPIO_Init(GPIOB, &GPIO_InitStruct);

    /* USART1 DMA Init */
    /* USART1_RX Init */
    hdma_sci_rx.Instance = DMA_Channel2;
    hdma_sci_rx.Init.Direction           = DMA_PERIPH_TO_MEMORY;
    hdma_sci_rx.Init.PeriphInc           = DMA_PADDR_FIX;
    hdma_sci_rx.Init.MemInc              = DMA_MADDR_INC;
    hdma_sci_rx.Init.PeriphDataAlignment = DMA_PDATAALIGN_BYTE;
    hdma_sci_rx.Init.MemDataAlignment    = DMA_MDATAALIGN_BYTE;
    hdma_sci_rx.Init.Mode                = DMA_NORMAL;
    hdma_sci_rx.Init.Priority            = DMA_PRIORITY_1;
    hdma_sci_rx.Init.TransMode           = DMA_TRANSFER_SINGLE;
    /* DMA initialization */
    if (HAL_DMA_Init(&hdma_sci_rx) != HAL_OK)
    {
      APP_ErrorHandler();
    }
    HAL_DMA_ChannelMap(&hdma_sci_rx, DMA_CHANNEL_MAP_USART1_RX);
    __HAL_LINKDMA(hsci, hdmarx, hdma_sci_rx);

    /* USART1_TX Init */
    hdma_sci_tx.Instance = DMA_Channel1;
    hdma_sci_tx.Init.Direction           = DMA_MEMORY_TO_PERIPH;
    hdma_sci_tx.Init.PeriphInc           = DMA_PADDR_FIX;
    hdma_sci_tx.Init.MemInc              = DMA_MADDR_INC;
    hdma_sci_tx.Init.PeriphDataAlignment = DMA_PDATAALIGN_BYTE;
    hdma_sci_tx.Init.MemDataAlignment    = DMA_MDATAALIGN_BYTE;
    hdma_sci_tx.Init.Mode                = DMA_NORMAL;
    hdma_sci_tx.Init.Priority            = DMA_PRIORITY_0;
    hdma_sci_tx.Init.TransMode           = DMA_TRANSFER_SINGLE;
    /* DMA initialization */
    if (HAL_DMA_Init(&hdma_sci_tx) != HAL_OK)
    {
      APP_ErrorHandler();
    }
    HAL_DMA_ChannelMap(&hdma_sci_tx, DMA_CHANNEL_MAP_USART1_TX);
    __HAL_LINKDMA(hsci, hdmatx, hdma_sci_tx);

    /* NVIC enable */
    HAL_NVIC_SetPriority(DMA_Channel1_IRQn, 1, 0);
    HAL_NVIC_EnableIRQ(DMA_Channel1_IRQn);
    HAL_NVIC_SetPriority(DMA_Channel2_3_IRQn, 1, 0);
    HAL_NVIC_EnableIRQ(DMA_Channel2_3_IRQn);

    /* USART1 interrupt Init */
    HAL_NVIC_SetPriority(USART1_IRQn, 1, 0);
    HAL_NVIC_EnableIRQ(USART1_IRQn);
  }
}

/************************ (C) COPYRIGHT Puya *****END OF FILE******************/
